/* Default linker command file for 5121 Bluestone board */


/* Memory map:
 *
 *
 * TEXT (application instruction ram)
 * +--------------------+ <- low memory
 * | .int_table         | Interrupt jump table
 * | .itext             |
 * | .text              |
 * |        _etext      |
 * +--------------------+
 *
 * DATA (application data ram)
 * +--------------------+ <- low memory
 * | .idata             |
 * | .data              | initialized data goes here
 * +--------------------+
 * | .bss               |
 * |        _clear_start| start of bss, cleared by crt0
 * |        _clear_end  | end of cleared area
 * |        _end        | start of heap, used by sbrk()
 * +--------------------+
 * |    heap space      |
 * +--------------------+
 * |    stack space     | 
 * |        __stack     | top of stack
 * +--------------------+ <- high memory
 *
 *
 */


/* STARTUP(task-crt0.S.o)
 */
INPUT(crti.o crtn.o)
GROUP(-lc -lsim -lgcc) 
ENTRY(_start)


/*
 * By defining the program headers (segments) and assigning the sections to it, we make sure the sections
 * VMA (virtual memory addreass) and LMA (load memory address) are identical. This is needed because when
 * extracting sections from the final elf file and saving them as s-records (using objdump) LMA is used.   
 */

PHDRS
{
  seg_inttab PT_LOAD ;
  seg_imem   PT_LOAD ;
  seg_dmem   PT_LOAD ;
}


/*
 *  Define the memory areas. All addresses are specified from a PXE
 *  view after initialization of the instruction & data address
 *  decoder.
 */

MEMORY
{
  inttab : ORIGIN = 0x00000000, LENGTH = 512   /* AXE interrupt jump table */
  imem   : ORIGIN = 0x00080000, LENGTH = 4M    /* AXE instruction memory mapped in DDR */
  dmem   : ORIGIN = 0x30000000, LENGTH = 4M    /* AXE data memory mapped in SRAM*/
}

PROVIDE (__stack = 0x3000FFF8);                  /* Set in the middle of SRAM to avoid stepping on Scheduler for now */
PROVIDE (_hardware_init_hook = 0x0000);      /* no hardware init routines needed */




/*
 * stick everything in ram (of course)
 */
SECTIONS
{
        /*
         * Interrupt jump table use the first 0x200 bytes of IRAM
         * Debugger uses first 4entries = 16bytes
         */

        INTTAB : {
                *(.int_table)
        } > inttab :seg_inttab


        /*
         * Code which is mapped to external or internal memory
         * SNE has only internal memory!
         */
        TEXT : {
		*(.itext)
                *(.text)

		/*
		 * C++ constructors/destructors
		 */
		*(.gnu.linkonce.t.*)

		/*
		 * Initialization and finalization code.
     		 *
     		 * Various files can provide initialization and finalization
		 * functions.  crtbegin.o and crtend.o are two instances. The
		 * body of these functions are in .init and .fini sections. We
		 * accumulate the bodies here, and prepend function prologues
		 * from crti.o and function epilogues from crtn.o. crti.o must
		 * be linked first; crtn.o must be linked last.  Because these
		 * are wildcards, it doesn't matter if the user does not
		 * actually link against crti.o and crtn.o; the linker won't
		 * look for a file to match a wildcard.  The wildcard also
		 * means that it doesn't matter which directory crti.o and
		 * crtn.o are in. 
		 */
		PROVIDE (_init = .);
		*crti.o(.init)
		*(.init)
		*crtn.o(.init)
		PROVIDE (_fini = .);
		*crti.o(.fini)
		*(.fini)
		*crtn.o(.fini)

		/*
		 * C++ constructors/destructors
     		 *
     		 * gcc uses crtbegin.o to find the start of the constructors
		 * and destructors so we make sure it is first.  Because this
		 * is a wildcard, it doesn't matter if the user does not
		 * actually link against crtbegin.o; the linker won't look for
		 * a file to match a wildcard.  The wildcard also means that
		 * it doesn't matter which directory crtbegin.o is in. The
		 * constructor and destructor list are terminated in
		 * crtend.o.  The same comments apply to it.
		 */
		. = ALIGN (16);
		*crtbegin.o(.ctors)
		*(.ctors)
		*crtend.o(.ctors)
		*crtbegin.o(.dtors)
		*(.dtors)
		*crtend.o(.dtors)

		/*
		 * Exception frame info
		 */
		. = ALIGN (16);
		*(.eh_frame)

                 . = ALIGN (16);
                PROVIDE (_etext = .);
        } > imem :seg_imem


        /*
         * Data which is mapped to internal or external memory
         */
        DATA : {
                PROVIDE (_copy_start = .);
		*(.idata)
                *(.data)
		*(.gnu.linkonce.d*)
		*(.gcc_except_table)
                . = ALIGN (16);

		/*
		 * Read-only data
		 */
		. = ALIGN (16);

		_rodata_start = . ;
		*(.rodata.*)
		*(.rodata)
		*(.gnu.linkonce.r*)

		. = ALIGN (16);
                PROVIDE (_edata = .);
                PROVIDE (_copy_end = .);

		/*
		 * .bss
		 */
                _clear_start = .;
                *(.bss)
                *(COMMON)
                . = ALIGN (16);
                _clear_end = .;

                _end = .;
                __WorkspaceBase = .;
        } >dmem :seg_dmem


	/*

  /* Stabs debugging sections.  */
  .stab          0 : { *(.stab) }
  .stabstr       0 : { *(.stabstr) }
  .stab.excl     0 : { *(.stab.excl) }
  .stab.exclstr  0 : { *(.stab.exclstr) }
  .stab.index    0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment       0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
}
